-- module Greedy where

import Point
import List
import Control.Exception
import System.CPUTime

type Pointg a = (Point a,Point a)
type PointGr a = ((Point a),Int)
type PointDist a = (a,Point a,Point a)


data (Ord a, Read a, Show a, (Show [[PointGr a]])) =>
    Condicao a =
	  PertTourG01 [PointGr a] [PointGr a]	--apenas um dos pts estao no tour
	| PertTourG11 [PointGr a] [PointGr a]	--os 2 pts estao no tour e tem grau 1
	| PertTourG2 				--algum dos pts tem grau 2
	| NotTour 				--ambos tem grau 0S
	deriving (Eq,Read,Show)

-----------------------------------------------------------------------------------------------------

main = readIntPts [] >>= \pts -> let tour = greedy pts
                                 in putStr (showPoints (tour))

-- tourOK pts tour = assert (sort pts == sort tour) tour

----------------------------GREEDY-------------------------------------------------------------------

greedy 		:: 	(Ord a, Read a, Num a) =>
			[Point a] -> [Point a]
filterDegree 	::	[PointGr a] -> [Point a]
filterDist 	:: 	[PointDist a] -> [Pointg a]
aux 		:: 	(Eq a, Show a, Ord a, Read a) =>
			[Pointg a] -> [[PointGr a]] -> [[PointGr a]]
degreeP		:: 	(Eq a, Show a, Ord a, Read a) =>
			Pointg a -> [[PointGr a]] -> Condicao a
riseDegree 	:: 	(Eq a) =>
			Point a -> [PointGr a] -> [PointGr a]
insertP 	:: 	(Eq a) =>
			Point a -> Point a -> [PointGr a] -> [PointGr a]
isHead 		:: 	(Eq a) =>
			Point a -> [PointGr a] -> Bool
mergeTour 	:: 	(Eq a) =>
			Point a -> Point a -> [PointGr a] -> [PointGr a] -> [PointGr a]
makeEdges 	:: 	(Num a) =>
			[Point a] -> [PointDist a]

----------------------------------------------------------------------------------------------------

greedy xs	=	filterDegree (head( aux(filterDist(qsort( makeEdges xs )))[ ] ))

filterDegree xs	=	[ a | (a,grau)<-xs ]

filterDist xs	=	[ (a,b) | (d,a,b)<-xs ]

distance (a,b) (c,d)	=	(a-c)*(a-c) + (b-d)*(b-d)

makeEdges [ ]		=	error ( "Input invalido" )
makeEdges [a]		=	[ ]
makeEdges (a:xs)	=	[ (distance a b, a, b) | b<-xs ] ++ makeEdges xs


-- a e b sao pontos... juntos formam uma aresta!

aux [ ] tour		=	tour
aux ((a,b):listOrd) [ ]	=	aux listOrd [ [(a,1),(b,1)] ]

aux ((a,b):listOrd) tour=
  let	tour01 xs ys =
		if	( xs /= [ ] )
		then	( insertP b a ( riseDegree a xs ) ) : ( tourWoutX xs )
		else	( insertP a b ( riseDegree b ys ) ) : ( tourWoutX ys )
	tour11 xs ys	=	( mergeTour a b xs ys ):( tourWoutXY xs ys )
	tourWoutX  xs	=	delete xs tour
	tourWoutXY xs ys=	delete xs ( tourWoutX ys )
  in
  case	( degreeP (a,b) tour ) of
	PertTourG01 xs ys	->	aux listOrd ( tour01 xs ys )
	PertTourG11 xs ys	->	aux listOrd ( tour11 xs ys )
	PertTourG2		->	aux listOrd tour
	NotTour			->	aux listOrd ( [(a,1),(b,1)] : tour )

--(a,b) aresta

degreeP (a,b) tour
	| (emptyA)&&(a2)		=	PertTourG2
	| (emptyB)&&(b2)		=	PertTourG2
	| (emptyA)&&(a1)&&(not emptyB)	=	PertTourG01 tourA [ ]
	| (emptyB)&&(b1)&&(not emptyA)	=	PertTourG01 [ ] tourB
	| (emptyA)&&(a1)&&(emptyB)&&(b1)=	PertTourG11 tourA tourB
	| otherwise  			=	NotTour
  where	tourA				=	subTour a tour
	tourB				=	subTour b tour
	grauA				=	head [ g | (c,g)<-tourA, a==c ]
	grauB				=	head [ g | (c,g)<-tourB, b==c ]
	(a1,b1)				=	(grauA == 1, grauB == 1)
	(a2,b2)				=	(not a1, not b1)
	(emptyA,emptyB)			=	(tourA /= [ ],tourB /= [ ])

subTour _ [] = []
subTour a (xs:tour)
	| (elem (a,1) xs)	=	xs
	| (elem (a,2) xs)	=	xs
	| otherwise		=	subTour a tour

riseDegree a xs
	| isHead a xs		=	ptoA : ( tail xs )
	| otherwise		=	( init xs ) ++ [ptoA]
  where	ptoA			=	head [ (a, grau+1) | (c,grau)<-xs, a==c ]

-- insere b com a ja no tour

insertP b a xs
	| isHead a xs	=	( (b,1) : xs )
	| otherwise	=	( xs ++ [(b,1)] )

-- retorna se a eh head ou last
isHead a [ ]		=	False
isHead a ((b,_):xs)	=	( a == b )

mergeTour _ _ [] []	=	[]
mergeTour _ _ [] ys	=	ys
mergeTour _ _ xs []	=	xs
mergeTour a b xs ys
	| ( headA && headB )	=
		((reverse (riseDegree a xs)) ++ riseDegree b ys)
	| ( headA && (not headB) )	=
		(riseDegree b ys ++ riseDegree a xs)
	| ( (not headA) && headB )	=
		(riseDegree a xs ++ riseDegree b ys)
	| ( (not headA) && headB )	=
		(riseDegree a xs ++ (reverse (riseDegree b ys)))
	| ( xs == ys )	=	xs
-- 	| otherwise	=	ys
  where	headA	=	isHead a xs
	headB	=	isHead b ys

-------------------------------------------------------------------------------------------------------------------

qsD :: Ord a => [PointDist a] -> [PointDist a] -> [PointDist a]
partitionD :: Ord a => PointDist a -> [PointDist a] -> [PointDist a] -> [PointDist a] -> ([PointDist a],[PointDist a])

qsort list	=	qsD list []

qsD [] list	=	list
qsD [x] list	=	x:list
qsD (x:xs) list =	qsD left (x : qsD right list)
  where	(left,right)	=	 partitionD x xs [] []

partitionD (d,x,y) [] l r	=	(l,r)
partitionD (d,x,y) ((d1,a,b):xs) l r
	| d1 <= d	=	partitionD (d,x,y) xs ((d1,a,b):l) r
	| otherwise	=	partitionD (d,x,y) xs l ((d1,a,b):r)

